#define WIN32_LEAN_AND_MEAN

#include <winsock2.h>
#include <iostream>
#include <sstream>
#include <stdlib.h>

#pragma comment (lib, "Ws2_32.lib")

#define DEFAULT_BUFLEN	4069
#define DEFAULT_PORT	27015

using namespace std;

int __cdecl main(void)
{
	WSADATA wsData;
	SOCKET listening, slave;
	sockaddr_in hint;
	fd_set master;
	bool Looping = true;
	int ConnectCount;
	string szMsg;

	if (WSAStartup(MAKEWORD(2, 2), &wsData) != EXIT_SUCCESS)
	{
		cout << "Can't Initialize WinSock! Quitting..." << endl;
		return EXIT_FAILURE;
	}
	if ((listening = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
	{
		cerr << "Can't create a socket! Quitting" << endl;
		WSACleanup();
		return EXIT_FAILURE;
	}
	else
		cout << "Creating a Socket..." << endl;

	hint.sin_family = AF_INET;
	hint.sin_port = htons(DEFAULT_PORT);
	hint.sin_addr.S_un.S_addr = INADDR_ANY;//inet_addr("127.0.0.1");//

	if (bind(listening, (sockaddr*)&hint, sizeof(hint)) == SOCKET_ERROR)
	{
		cout << "Bind failed with error:" << WSAGetLastError() << endl;
		WSACleanup();
		return EXIT_FAILURE;
	}
	else
		cout << "Bind success..." << endl;

	if (listen(listening, SOMAXCONN) == SOCKET_ERROR)
	{
		cout << "Listen failed with error:" << WSAGetLastError() << endl;
		WSACleanup();
		return EXIT_FAILURE;
	}
	else
		cout << "Listen success..." << endl;
	
	FD_ZERO(&master);
	FD_SET(listening, &master);
	cout << "Waiting for client connection" << endl;

	while (Looping)
	{
		fd_set tmp = master;

		ConnectCount = select(0, &tmp, nullptr, nullptr, nullptr);
		for (int c0 = 0; c0 < ConnectCount; c0++)
		{
			if ((slave = tmp.fd_array[c0]) == listening)
			{
				SOCKET NewClient = accept(listening, nullptr, nullptr);

				szMsg = "Sent by SERVER: Welcome to Mini Chart\r\n";
				FD_SET(NewClient, &master);
				send(NewClient, szMsg.c_str(), (int)szMsg.size() + 1, 0);
				cout << "Client #" << NewClient << " connecting..." << endl;
			}
			else
			{
				char buff[DEFAULT_BUFLEN];
				int bytesIn;

				ZeroMemory(buff, DEFAULT_BUFLEN);
				if ((bytesIn = recv(slave, buff, DEFAULT_BUFLEN, 0)) <= 0)
				{
					closesocket(slave);
					cout << "Client #" << slave << " disconnected..." << endl;
					FD_CLR(slave, &master);
				}
				else
				{
					if (buff[0] == '\\') //Check command ...
					{
						szMsg = string(buff, bytesIn);

						if (szMsg == "\\shutdown")
						{
							Looping = false;
							break;
						}
						continue;
					}
					for (u_int c1 = 0; c1 < master.fd_count; c1++)
					{
						SOCKET out = master.fd_array[c1];

						if ((out != listening) && (out != slave))
						{
							ostringstream s1;

							s1 << "Client #" << slave << ": " << buff << "\r\n";
							send(out, s1.str().c_str(), (int)s1.str().size() + 1, 0);
						}
					}
				}

			}
		}
	}

	FD_CLR(listening, &master);
	closesocket(listening);
	szMsg = "Server is shutting down. Goodbye\r\n";
	while (master.fd_count > 0)
	{
		slave = master.fd_array[0];
		send(slave, szMsg.c_str(), (int)szMsg.size() + 1, 0);
		FD_CLR(slave, &master);
		closesocket(slave);
	}

	WSACleanup();

	return EXIT_SUCCESS;
}
